package jp.kawakubo;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name = "BASKET")
public class Basket implements Serializable {

    private int id = 0;
    private String userId = null;
    private List<BasketItem> basketItems = null;

    public Basket(){
    }

    public Basket(int id,
                String userId,
                List<BasketItem> basketItems) {
        this.id = id;
        this.userId = userId;
        this.basketItems = basketItems;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name = "ID")
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column(name = "USER_ID")
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @OneToMany(targetEntity = BasketItem.class,
        mappedBy = "basket")
    public List<BasketItem> getBasketItems() {
        return basketItems;
    }

    public void setBasketItems(List<BasketItem> basketItems) {
        this.basketItems = basketItems;
    }

}
